function PlotPyknogGram(pyknogram, ntaps, samplerate)
	% PlotPyknoGram(pyknogram, ntaps, samplerate)
	%
	%
	% pykfec - pyknogram frequency estimated coefficients toolbox for Matlab/Octave
	% Copyright (C) <2008>  <Marco.Grimaldi@gmail.com>
	%
	%
	% plots the input pyknogram as scatterplot
	% Input:
	%	pyknogram:		input pyknogram
	%	ntaps:			number of taps used to calculate the pyknogram
	%	samplerate:		sample rate of the signal
	%
	% See also:
	%	PyknoGram
	
	dims = size(pyknogram);
	plot( (1:dims(1))/samplerate*ntaps/2, pyknogram.*samplerate,'.k' );
end