function stfe = ShortTimeFrequencyEstimate(a,f, dT)
	% stfe = ShortTimeFrequencyEstimate(a,f, dT)
	%
	%
	% pykfec - pyknogram frequency estimated coefficients toolbox for Matlab/Octave
	% Copyright (C) <2008>  <Marco.Grimaldi@gmail.com>
	%
	%
	% DOES NOT WORK IN CASE THE INPUTS ARE MATRICES!
	%
	% Input:
	%	a:		instantaneous amplitude
	%	b:		instantaneous frequency
	%	dT:		interval to be considered for integration
	%
	% See also:
	%	PyknoGram, InstFrequency 
	
	stfe = zeros(1,floor(2*length(a)/dT)-2);

	counter = 0;
	for i = 1:length(stfe)
		first = floor(dT/2)*counter+1;
		last =  first+dT-1;
		stfe(i) = sum( (a(first:last).^2) .* f(first:last))/sum( (a(first:last).^2));
		counter=counter+1;
	end
end
