function [filterbank, centerFrequency] = LinearGaborFilterBankMelBandwidth (nFilters, nTaps, e_rms_bw, SampleRate, lowF, hiF)
	% [filterbank centerFrequency]= GaborFilterBank (nFilters, nTaps, e_rms_bw, SampleRate), lowF, hiF)
	%
	%
	% pykfec - pyknogram frequency estimated coefficients toolbox for Matlab/Octave
	% Copyright (C) <2008>  <Marco.Grimaldi@gmail.com>
	%
	%
	% Creates a bank of Gabor filters with center frequencies linearly spaced beween lowF and HiF 
	% and constant bandwidh on the Mel scale
	%
	% Input and Outputs are as follows:
	% Input:
	% 	nFilters:		number of desired filters in the bank
	% 	nTaps:			number of taps in each filter
	% 	e_rms_bw:		Effective RMS BandWidth  in Hz
	%	SampleRate:		sample-rate of the signal to be processed in Hz
	%	lowF:			lowest frequency in the filterbank in Hz
	%	hiF:			highest frequency in the filterbank in Hz
	%
	% Output:
	%	filterbank: 		matrix nFilters x nTaps containing the filterbank
	%	centerFrequency:	vector containing the (normalized) center frequency of each filter
	
	%linerly (in Hz) spaced gabor filterbank
	%calculating center frequencies (Normalized Frequency)
	centerFrequency = lowF/SampleRate:(hiF-lowF)/SampleRate/(nFilters-1):hiF/SampleRate;
	
	%linear (in Mel) bandwidth
	%the bandwidths are rescaled in Hz according to the conversion Mel <-> Hz
	%the e_rms_bw in Hz is converted in e_rms_bw in Mel at 1000Hz - where the two curves meet 1000Hz == 1000Mel
	e_rms_bw_mel = frq2mel(1000 + e_rms_bw/2) - frq2mel(1000 - e_rms_bw/2);
	centerFrequency_mel = frq2mel(centerFrequency.*SampleRate);
	
	e_rms_bw_hz = mel2frq( centerFrequency_mel + e_rms_bw_mel/2 ) - mel2frq(centerFrequency_mel-e_rms_bw_mel/2);
		
	alpha = e_rms_bw_hz./SampleRate;
	
	filterbank = zeros (nFilters,nTaps);
	for i = 1:nFilters
		filterbank(i,:) = Gabor(alpha(i),centerFrequency(i),nTaps);
	end
end