function instfreq = InstFrequency(asig)
	% instfreq = InstFrequency(asig)
	%
	%
	% pykfec - pyknogram frequency estimated coefficients toolbox for Matlab/Octave
	% Copyright (C) <2008>  <Marco.Grimaldi@gmail.com>
	%
	%
	% Calculates the instantaneous frequency from the input analytic signal.
	% If asig is a matrix, the calculations are done column-wise. If asig is 
	% a N-D array, calculations are done along the first non-singleton dimension.
	%
	% Input:
	%	asig:	input analyic signal
	%
	% See also:
	%	ShortTimeFrequencyEstimate, PyknoGram
	
	% Input handling
	if (nargin<1 || nargin>1)
    		error('this function requires one input parameter: instfreq = InstFrequency(asig);'); 
    	end
    	if isreal(asig)
    		error('this function requires a complex-valued input.');
	end
  	if isscalar(asig)
  		error ('this function requires a vector or a matrix as input.');
  	end
	
	transpose = 0;
	if isvector(asig)
		if size(asig,1) == 1
			asig = asig.';
			transpose = 1
		end
	end
	
	phase = unwrap(angle(asig));
	
	instfreq = diff(phase)/(2*pi);
	instfreq = [instfreq; instfreq(end,:)];
	
	if transpose == 1
		instfreq = instfreq.';
	end
end
