function [filterbank, centerFrequency] = GaborFilterBank (nFilters, nTaps, e_rms_bw, SampleRate, lowF, hiF)
	% [filterbank centerFrequency]= GaborFilterBank (nFilters, nTaps, e_rms_bw, SampleRate), lowF, hiF)
	%
	%
	% pykfec - pyknogram frequency estimated coefficients toolbox for Matlab/Octave
	% Copyright (C) <2008>  <Marco.Grimaldi@gmail.com>
	%
	%
	% Creates a bank of Gabor filters linearly spaced beween lowF and HiF
	% Input and Outputs are as follows:
	% Input:
	% 	nFilters:		number of desired filters in the bank
	% 	nTaps:			number of taps in each filter
	% 	e_rms_bw:		Effective RMS BandWidth 
	%	SampleRate:		sample-rate of the signal to be processed
	%	lowF:			lowest frequency in the filterbank	
	%	hiF:			highest frequency in the filterbank
	%
	% Output:
	%	filterbank: 		matrix nFilters x nTaps containing the filterbank
	%	centerFrequency:	vector containing the (normalized) center frequency of each filter
	
	centerFrequency = lowF/SampleRate:(hiF-lowF)/SampleRate/(nFilters-1):hiF/SampleRate;
	alpha = e_rms_bw/SampleRate;
	filterbank = zeros (nFilters,nTaps);
	for i = 1:nFilters
		filterbank(i,:) = Gabor(alpha,centerFrequency(i),nTaps);
	end
end